;/**********************************************
; Program		:Test the Relay on Port PA.7.
; File Name		:Relay.asm
; CPU Controller:ATmega163
; AVR Aseembler	:AVR Studio 4.05
;/**********************************************
.include "m163def.inc"			
			.org   	$000 
    		rjmp  reset					;Reset Handle

;/************************
; Define Register
;/************************
.def		counter1  	= r16
.def		counter2	= r17
.def		counter3	= r18
.def		temp		= r19

;/*******************
; Main Program
;/*******************
reset:      ldi	temp,low(RAMEND)
            out	SPL,temp          	;init Stack Pointer     
            ldi	temp,high(RAMEND)
            out	SPH,temp        	
			sbi	DDRA,7
loop:		rcall	delay200ms
			sbi	PORTA,7
			rcall	delay200ms
			cbi	PORTA,7
			rjmp	loop

;/****************
; delay Time
;/****************
delay1ms:	push	counter1
			push	counter2
			ldi	counter1,8
delay1ms_1: ldi    	counter2,250
delay1ms_2: nop
			dec   	counter2
            brne   	delay1ms_2
            dec    	counter1
            brne   	delay1ms_1
            pop	counter2
			pop	counter1
			ret          

delay200ms:	push	counter3
			ldi	counter3,200
delay200ms_1:	
			rcall	delay1ms
			dec	counter3
			brne	delay200ms_1
			pop	counter3
			ret
